; //--------------------- Constants -------------------------------

; genral definitions
#define ZERO c-91.x
#define ONE c-91.y
#define PI c-91.z
#define EPSILON c-91.w
#define R_MODEL_VERT r0
#define R_MODEL_NORMAL r1

; fog definitions
#define R_VERT_TO_FOG r5
#define R_VERT_TO_INTERSECT r6
#define R_VERT_DISTANCE r7
#define R_INTERSECT_DISTANCE r8
#define IS_ZERO	r9
#define IS_NEG r10
#define R_FOG r11

; lighting definitions
#define R_TEMP r6
#define R_VERT_TO_LIGHT r7
#define R_ATTENUATION r8
#define R_INTENSITY r9
#define R_DIFFUSE r10
#define R_SPECULAR r11

; //--------------------- Version -------------------------------

; vertex shader version 1.1
xvs.1.1

; //--------------- Apply Vertex Weights ------------------------

; first bone
mov	a0.x, v4.x
mul	r2, v5.x, c[ a0.x + 0 ]
mul	r3, v5.x, c[ a0.x + 1 ]
mul	r4, v5.x, c[ a0.x + 2 ]

; second bone
mov	a0.x, v4.y
mad	r2, v5.y, c[ a0.x + 0 ], r2
mad	r3, v5.y, c[ a0.x + 1 ], r3
mad	r4, v5.y, c[ a0.x + 2 ], r4

; third bone
mov	a0.x, v4.z
mad	r2, v5.z, c[ a0.x + 0 ], r2
mad	r3, v5.z, c[ a0.x + 1 ], r3
mad	r4, v5.z, c[ a0.x + 2 ], r4

; transform weighted position
dp4	R_MODEL_VERT.x, v0, r2
dp4	R_MODEL_VERT.y, v0, r3
dp4	R_MODEL_VERT.z, v0, r4
mov R_MODEL_VERT.w, ONE

; rotate weighted normal
dp3	R_MODEL_NORMAL.x, v1, r2
dp3	R_MODEL_NORMAL.y, v1, r3
dp3	R_MODEL_NORMAL.z, v1, r4

; //------------------- Xform Vertices -----------------------------

;transform vertices by view/projection matrix
m4x4 oPos, R_MODEL_VERT, c-96

; //----------------- Calculate Texture UV -------------------------

;copy texture coordinates to output   
mov oT0.xy, v3

; //--------------------- Calculate Fog ----------------------------

;calculate vertex-to-fog vector
add R_VERT_TO_FOG, c-92, -R_MODEL_VERT	
dp3 R_VERT_DISTANCE.w, R_VERT_TO_FOG, R_VERT_TO_FOG
rsq R_VERT_TO_FOG.w, R_VERT_DISTANCE.w

; calculate vertex-to-fog distance
dst R_VERT_DISTANCE, R_VERT_DISTANCE.wwww, R_VERT_TO_FOG.wwww

; calculate range based fog
mad oFog.x, R_VERT_DISTANCE.y, c-80.x, c-80.y

; //------------------- Calculate Lighting -------------------------

; //--------------------- Ambient Light ----------------------------

; accumulate ambient light
mov R_DIFFUSE, c-70

; //----------------------- Light One ------------------------------
; point light with linear attenuation

;calculate vertex-to-light vector
add R_VERT_TO_LIGHT, c-62, -R_MODEL_VERT	
dp3 R_INTENSITY.x, R_VERT_TO_LIGHT, R_VERT_TO_LIGHT
rsq R_VERT_TO_LIGHT.w, R_INTENSITY.x	

; calculate R_ATTENUATION
dst R_TEMP, R_INTENSITY.xxxx, R_VERT_TO_LIGHT.wwww  ; ( 1, d, d * d, 1/d )
dp3 R_TEMP.w, R_TEMP, c-63							; ( a0 + a1 * d + a2 * d2 )
rcp R_ATTENUATION.w, R_TEMP.w						; 1 / (a0 + a1 * d + a2 * d )

; dot light direction with vertex-to-light vector 
dp3 R_INTENSITY.y, c-64, R_VERT_TO_LIGHT
min R_INTENSITY.y, R_INTENSITY.y, ZERO
mul R_INTENSITY.y, R_INTENSITY.y, R_INTENSITY.y

; normalize the vertex-to-light vector
mul R_VERT_TO_LIGHT, R_VERT_TO_LIGHT, R_VERT_TO_LIGHT.w	

; dot normal with light vector 
dp3 R_INTENSITY.z, R_MODEL_NORMAL, R_VERT_TO_LIGHT
max R_INTENSITY.z, R_INTENSITY.z, ZERO

; construct numerator 
mul R_TEMP.x, c-65.x, R_INTENSITY.x
add R_TEMP.x, R_INTENSITY.y, -R_TEMP.x
; construct denominator
mul R_TEMP.w, c-65.y, R_INTENSITY.y
rcp R_TEMP.w, R_TEMP.w
;// multiply
mul R_TEMP.z, R_TEMP.x, R_TEMP.w
;// max
max R_TEMP.z, R_TEMP.z, c-65.z

; accumulate intensity
mul R_INTENSITY.z, R_INTENSITY.z, R_ATTENUATION.w
mul R_INTENSITY.z, R_INTENSITY.z, R_TEMP.z

; accumulate diffuse light
mad R_DIFFUSE, R_INTENSITY.z, c-61, R_DIFFUSE
; accumulate ambient light
mad R_DIFFUSE, R_INTENSITY.z, c-60, R_DIFFUSE

; //---------------------- Light Two -----------------------------
; point light with linear attenuation

;calculate vertex-to-light vector
add R_VERT_TO_LIGHT, c-52, -R_MODEL_VERT	
dp3 R_INTENSITY.x, R_VERT_TO_LIGHT, R_VERT_TO_LIGHT
rsq R_VERT_TO_LIGHT.w, R_INTENSITY.x	

; calculate R_ATTENUATION
dst R_TEMP, R_INTENSITY.xxxx, R_VERT_TO_LIGHT.wwww  ; ( 1, d, d * d, 1/d )
dp3 R_TEMP.w, R_TEMP, c-53							; ( a0 + a1 * d + a2 * d2 )
rcp R_ATTENUATION.w, R_TEMP.w						; 1 / (a0 + a1 * d + a2 * d )

; dot light direction with vertex-to-light vector 
dp3 R_INTENSITY.y, c-54, R_VERT_TO_LIGHT
min R_INTENSITY.y, R_INTENSITY.y, ZERO
mul R_INTENSITY.y, R_INTENSITY.y, R_INTENSITY.y

; normalize the vertex-to-light vector
mul R_VERT_TO_LIGHT, R_VERT_TO_LIGHT, R_VERT_TO_LIGHT.w	

; dot normal with light vector 
dp3 R_INTENSITY.z, R_MODEL_NORMAL, R_VERT_TO_LIGHT
max R_INTENSITY.z, R_INTENSITY.z, ZERO

; construct numerator 
mul R_TEMP.x, c-55.x, R_INTENSITY.x
add R_TEMP.x, R_INTENSITY.y, -R_TEMP.x
; construct denominator
mul R_TEMP.w, c-55.y, R_INTENSITY.y
rcp R_TEMP.w, R_TEMP.w
;// multiply
mul R_TEMP.z, R_TEMP.x, R_TEMP.w
;// max
max R_TEMP.z, R_TEMP.z, c-55.z

; accumulate intensity
mul R_INTENSITY.z, R_INTENSITY.z, R_ATTENUATION.w
mul R_INTENSITY.z, R_INTENSITY.z, R_TEMP.z

; accumulate diffuse light
mad R_DIFFUSE, R_INTENSITY.z, c-51, R_DIFFUSE
; accumulate ambient light
mad R_DIFFUSE, R_INTENSITY.z, c-50, R_DIFFUSE

; //----------------------- Clamp Color --------------------------

max R_DIFFUSE, R_DIFFUSE, ZERO
min R_DIFFUSE, R_DIFFUSE, ONE
mov oD0, R_DIFFUSE

